/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.util.MultiFileFilter;
import com.install4j.runtime.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileSelector
extends JPanel
implements AbstractFileSelector {
    private static File lastDirectory = null;
    private JTextField txtFile;
    private JButton btnBrowse;
    private JFileChooser fileChooser;
    private String fileFilterName;
    private String[] filteredExtensions;
    private boolean designTime;
    private FileValidator validator;

    public FileSelector(String string, String[] stringArray, boolean bl) {
        this.fileFilterName = string;
        this.filteredExtensions = stringArray;
        this.designTime = bl;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setEnabled(boolean bl) {
        this.txtFile.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }

    public void initFile(String string) {
        this.txtFile.setText(string);
    }

    public void setSelectedFile(File file) {
        this.initFile(file.getPath());
    }

    public File getSelectedFile() {
        return new File(StringUtil.replaceHomeDir(this.txtFile.getText().trim()));
    }

    public void focusTextField() {
        this.txtFile.requestFocus();
        this.txtFile.setSelectionStart(0);
        this.txtFile.setSelectionEnd(this.txtFile.getDocument().getLength());
    }

    public JTextField getTextField() {
        return this.txtFile;
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    public void setManualEntryAllowed(boolean bl) {
        this.txtFile.setEditable(bl);
    }

    public void setValidator(FileValidator fileValidator) {
        this.validator = fileValidator;
    }

    private void setupControls() {
        this.txtFile = new JTextField(" ");
        VersionSpecificHelper.addFileDrop(this.txtFile, null);
        this.btnBrowse = new JButton(Messages.getMessages().getString("ButtonBrowse"));
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        this.add((Component)this.btnBrowse, gridBagConstraints);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSelector.this.doBrowse();
            }
        });
    }

    private void doBrowse() {
        File file;
        Object object;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogType(2);
            if (this.filteredExtensions != null && this.fileFilterName.trim().length() > 0) {
                for (int i = 0; i < this.filteredExtensions.length; ++i) {
                    object = this.filteredExtensions[i].trim();
                    if (((String)object).startsWith(".")) {
                        this.filteredExtensions[i] = ((String)object).substring(1);
                        continue;
                    }
                    if (!((String)object).startsWith("*.")) continue;
                    this.filteredExtensions[i] = ((String)object).substring(2);
                }
                this.fileChooser.addChoosableFileFilter(new MultiFileFilter(this.filteredExtensions, this.fileFilterName));
            }
        }
        if (this.txtFile.getText().trim().length() == 0) {
            if (lastDirectory == null) {
                lastDirectory = new File((String)ContextImpl.getSingleContextImpl().getVariable("sys.installerDirectory"));
            }
            file = lastDirectory;
        } else {
            file = new File(this.txtFile.getText());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(file.exists() && file.isDirectory() || (object = this.fileChooser.getFileSystemView().getParentDirectory(file)) == null || file.equals(object))) {
            file = object;
        }
        if (file.exists() && file.isDirectory()) {
            this.fileChooser.setCurrentDirectory(file);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            object = this.fileChooser.getSelectedFile();
            lastDirectory = ((File)object).getParentFile();
            if (this.validator == null || this.validator.isValidFile((File)object)) {
                this.txtFile.setText(((File)object).getPath());
            }
        }
    }

    public int getBaseline(int n, int n2) {
        int n3 = GUIHelper.getDelegateBaseline(this.txtFile, this.txtFile.getPreferredSize().width, this.txtFile.getPreferredSize().height);
        return n3 + (this.btnBrowse.getPreferredSize().height - this.txtFile.getPreferredSize().height) / 2;
    }
}

