/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.actions.Action;
import com.install4j.api.actions.UninstallAction;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.api.screens.UninstallerScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.IOException;

public class UninstallerContextImpl
extends ContextImpl
implements UninstallerContext {
    public UninstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return UninstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            public void setVariable(Object object) {
            }
        });
    }

    public void applyToScreen(Screen screen) {
        if (screen instanceof UninstallerScreen) {
            ((UninstallerScreen)screen).setUninstallerContext(this);
        }
    }

    public boolean performActionInt(Action action) throws UserCanceledException {
        return ((UninstallAction)action).uninstall(this);
    }

    public void rollbackActionInt(Action action) {
    }

    public boolean isUninstallForUpgrade() {
        return Boolean.getBoolean("install4j.upgradeUninstall");
    }

    public boolean checkStart() {
        ClasspathModificator.addCustomJarsToClasspath(this);
        try {
            Class.forName("__i4j_lock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return super.checkStart();
    }

    public void finish(int n) {
        try {
            FileInstaller.getInstance().finishUninstall();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        super.finish(n);
    }

    protected String getRebootMessageId() {
        return "UninstalledAndNeedsRestart";
    }
}

