/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.actions.desktop.CreateProgramGroupAction;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.UserInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StandardProgramGroupScreen
extends SystemScreen {
    private boolean allowUserChangeEnabled = true;
    private boolean allowUserChangeAllUsers = true;
    static /* synthetic */ Class class$com$install4j$runtime$beans$actions$desktop$CreateProgramGroupAction;

    public StandardProgramGroupScreen() {
        InstallerVariables.registerResponseFileVariable("sys.programGroup.name");
        InstallerVariables.registerResponseFileVariable("sys.programGroup.allUsers");
        InstallerVariables.registerResponseFileVariable("sys.programGroup.enabled");
        InstallerVariables.registerResponseFileVariable("sys.programGroup.linkDir");
    }

    public boolean isAllowUserChangeEnabled() {
        return this.allowUserChangeEnabled;
    }

    public void setAllowUserChangeEnabled(boolean bl) {
        this.allowUserChangeEnabled = bl;
    }

    public boolean isAllowUserChangeAllUsers() {
        return this.allowUserChangeAllUsers;
    }

    public void setAllowUserChangeAllUsers(boolean bl) {
        this.allowUserChangeAllUsers = bl;
    }

    protected SystemScreen.DefaultPanel createPanel() {
        if (Util.isWindowsInstaller()) {
            return new WindowsPanel();
        }
        return new UnixPanel();
    }

    public boolean isHidden() {
        CreateProgramGroupAction createProgramGroupAction = this.getCreateStandardProgramGroupAction();
        boolean bl = Util.isWindowsInstaller() || Util.isUnixInstaller();
        return createProgramGroupAction == null || !bl || Util.isUnixInstaller() && !createProgramGroupAction.isUnixSymlinks();
    }

    public void willActivate() {
        super.willActivate();
        this.getPanel().willActivate();
    }

    public void activated() {
        super.activated();
        this.getPanel().activated();
    }

    public boolean next() {
        return this.getPanel().next() && super.next();
    }

    protected boolean checkCompleted() {
        return this.getPanel().checkCompleted() && super.checkCompleted();
    }

    public String getTitle() {
        return Util.isWindowsInstaller() ? this.getMessage("WizardSelectProgramGroup") : this.getMessage("WizardSelectLinkDir");
    }

    public String getSubTitle() {
        return Util.isWindowsInstaller() ? this.getMessage("SelectStartMenuFolderDesc") : MessageFormat.format(this.getMessage("SelectLinkDirDesc"), this.getApplicationName());
    }

    public boolean isFillVertical() {
        return Util.isWindowsInstaller();
    }

    private CreateProgramGroupAction getCreateStandardProgramGroupAction() {
        return (CreateProgramGroupAction)this.getContext().getFirstAction(class$com$install4j$runtime$beans$actions$desktop$CreateProgramGroupAction == null ? (class$com$install4j$runtime$beans$actions$desktop$CreateProgramGroupAction = StandardProgramGroupScreen.class$("com.install4j.runtime.beans.actions.desktop.CreateProgramGroupAction")) : class$com$install4j$runtime$beans$actions$desktop$CreateProgramGroupAction, null);
    }

    private String getProgramGroupName() {
        CreateProgramGroupAction createProgramGroupAction = this.getCreateStandardProgramGroupAction();
        if (createProgramGroupAction == null) {
            return "";
        }
        createProgramGroupAction.updateProgramGroupName(this.getContext());
        return createProgramGroupAction.getProgramGroupName();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        CreateProgramGroupAction createProgramGroupAction = this.getCreateStandardProgramGroupAction();
        boolean bl = InstallerUtil.isWindows();
        if (this.allowUserChangeEnabled) {
            boolean bl2 = console.askYesNo(this.getMessage(bl ? "ConsoleProgramGroupCheck" : "ConsoleSymlinksCheck"), createProgramGroupAction.isEnabled());
            createProgramGroupAction.setEnabled(bl2);
            if (!bl2) {
                return true;
            }
        }
        if (bl) {
            createProgramGroupAction.setProgramGroupName(console.askString(this.getMessage("SelectStartMenuFolderDesc"), this.getProgramGroupName()));
            if (UserInfo.isAdminUser() && this.allowUserChangeAllUsers) {
                createProgramGroupAction.setAllUsers(console.askYesNo(this.getMessage("ProgramGroupAllUsers"), createProgramGroupAction.isAllUsers()));
            }
        } else {
            createProgramGroupAction.setLinkDirectory(console.askString(MessageFormat.format(this.getMessage("SelectLinkDirLabel"), this.getApplicationName()), createProgramGroupAction.getLinkDirectory()));
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UnixPanel
    extends SystemScreen.DefaultPanel
    implements ActionListener {
        private DirectorySelector directorySelector;
        private JCheckBox chkDisable;
        private boolean initialized;

        private UnixPanel() {
            super(StandardProgramGroupScreen.this);
        }

        public boolean next() {
            boolean bl = !this.chkDisable.isSelected();
            CreateProgramGroupAction createProgramGroupAction = StandardProgramGroupScreen.this.getCreateStandardProgramGroupAction();
            createProgramGroupAction.setEnabled(bl);
            if (bl) {
                createProgramGroupAction.setLinkDirectory(this.directorySelector.getSelectedFile().getPath());
            }
            return true;
        }

        public void willActivate() {
            super.willActivate();
            this.initDirectorySelector();
            this.checkEnabled();
        }

        private void initDirectorySelector() {
            if (!this.initialized) {
                String string = "/usr/bin";
                CreateProgramGroupAction createProgramGroupAction = StandardProgramGroupScreen.this.getCreateStandardProgramGroupAction();
                if (createProgramGroupAction != null) {
                    string = StandardProgramGroupScreen.this.getCreateStandardProgramGroupAction().getLinkDirectory();
                }
                string = StandardProgramGroupScreen.replaceVariables(string);
                this.directorySelector.initDirectory(new File(string), null);
                this.initialized = true;
            }
        }

        public void activated() {
            super.activated();
            this.directorySelector.focusTextField();
        }

        public boolean checkCompleted() {
            return (this.chkDisable.isSelected() || this.directorySelector.checkSelectedDirectory()) && super.checkCompleted();
        }

        protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
            StandardProgramGroupScreen.this.addDisplayTextArea(MessageFormat.format(StandardProgramGroupScreen.this.getMessage("SelectLinkDirLabel"), StandardProgramGroupScreen.this.getApplicationName()), jPanel, gridBagConstraints);
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.directorySelector, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                jPanel.add((Component)this.chkDisable, gridBagConstraints);
            } else {
                jPanel.add((Component)new JPanel(), gridBagConstraints);
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 3;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.chkDisable) {
                this.checkEnabled();
            }
        }

        protected void setupControls() {
            super.setupControls();
            this.directorySelector = new DirectorySelector(StandardProgramGroupScreen.this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), false);
            this.directorySelector.activateNextScreenOnEnter(StandardProgramGroupScreen.this.getContext().getWizardContext());
            this.chkDisable = new JCheckBox(StandardProgramGroupScreen.this.getMessage("NoSymlinksCheck"));
        }

        protected void setupComponent() {
            super.setupComponent();
            this.checkEnabled();
        }

        protected void setupEventHandlers() {
            super.setupEventHandlers();
            this.chkDisable.addActionListener(this);
        }

        private void checkEnabled() {
            boolean bl = !this.chkDisable.isSelected();
            this.directorySelector.setEnabled(bl);
            JTextField jTextField = this.directorySelector.getTextField();
            if (bl) {
                jTextField.selectAll();
            } else {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(0);
            }
        }
    }

    private class WindowsPanel
    extends SystemScreen.DefaultPanel
    implements ActionListener {
        private ProgramGroupSelector programGroupSelector;
        private JCheckBox chkDisable;
        private JCheckBox chkAllUsers;

        private WindowsPanel() {
            super(StandardProgramGroupScreen.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.chkDisable) {
                this.checkEnabled();
            } else if (object == this.chkAllUsers) {
                this.programGroupSelector.setAllUsers(this.chkAllUsers.isSelected());
            }
        }

        public boolean next() {
            CreateProgramGroupAction createProgramGroupAction = StandardProgramGroupScreen.this.getCreateStandardProgramGroupAction();
            String string = this.programGroupSelector.getSelectedProgramGroup();
            boolean bl = this.chkAllUsers.isSelected();
            boolean bl2 = !this.chkDisable.isSelected();
            createProgramGroupAction.setProgramGroupName(string);
            createProgramGroupAction.setAllUsers(bl);
            createProgramGroupAction.setEnabled(bl2);
            return true;
        }

        public void willActivate() {
            super.willActivate();
            CreateProgramGroupAction createProgramGroupAction = StandardProgramGroupScreen.this.getCreateStandardProgramGroupAction();
            if (createProgramGroupAction.isAllUsers() != this.chkAllUsers.isSelected()) {
                this.programGroupSelector.setAllUsers(createProgramGroupAction.isAllUsers());
            }
            this.programGroupSelector.setInitialProgramGroupName(StandardProgramGroupScreen.this.getProgramGroupName());
            this.chkAllUsers.setSelected(createProgramGroupAction.isAllUsers());
            this.chkDisable.setSelected(!createProgramGroupAction.isEnabled());
            this.checkEnabled();
        }

        public void activated() {
            this.programGroupSelector.focusTextField();
        }

        public boolean checkCompleted() {
            return this.chkDisable.isSelected() || this.programGroupSelector.checkSelectedProgramGroup();
        }

        protected void setupControls() {
            super.setupControls();
            this.programGroupSelector = new ProgramGroupSelector(true, StandardProgramGroupScreen.this.getContext().getWizardContext());
            this.chkDisable = new JCheckBox(StandardProgramGroupScreen.this.getMessage("NoProgramGroupCheck2"));
            this.chkAllUsers = new JCheckBox(StandardProgramGroupScreen.this.getMessage("ProgramGroupAllUsers"));
            this.chkAllUsers.setSelected(true);
        }

        protected void setupComponent() {
            super.setupComponent();
            this.checkEnabled();
        }

        protected void setupEventHandlers() {
            super.setupEventHandlers();
            this.chkDisable.addActionListener(this);
            this.chkAllUsers.addActionListener(this);
        }

        protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
            StandardProgramGroupScreen.this.addDisplayTextArea(StandardProgramGroupScreen.this.getMessage("SelectStartMenuFolderLabel"), jPanel, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)this.programGroupSelector, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            if (UserInfo.isAdminUser() && StandardProgramGroupScreen.this.allowUserChangeAllUsers) {
                gridBagConstraints.insets.bottom = StandardProgramGroupScreen.this.allowUserChangeEnabled ? 0 : 5;
                jPanel.add((Component)this.chkAllUsers, gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets.top = 0;
            }
            gridBagConstraints.insets.bottom = 5;
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                jPanel.add((Component)this.chkDisable, gridBagConstraints);
            } else {
                jPanel.add((Component)new JPanel(), gridBagConstraints);
            }
            ++gridBagConstraints.gridy;
        }

        private void checkEnabled() {
            boolean bl = !this.chkDisable.isSelected();
            this.programGroupSelector.setEnabled(bl);
            this.chkAllUsers.setEnabled(bl);
        }
    }
}

