/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesWriteAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.VariableEncoding;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;

public class SaveInstallerVariablesAction
extends PreferencesWriteAction {
    private String[] installerVariables;

    public String[] getInstallerVariables() {
        return SaveInstallerVariablesAction.replaceVariables(this.installerVariables);
    }

    public void setInstallerVariables(String[] stringArray) {
        this.installerVariables = stringArray;
    }

    public boolean execute(Context context) throws UserCanceledException {
        String[] stringArray = this.getInstallerVariables();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        final Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = context.getVariable(string);
            if (VariableEncoding.encodeVariable(properties, string, object) || object == null) continue;
            Logger.getInstance().log(this, "The variable " + string + " of type " + object.getClass().getName() + " cannot be encoded to a string", false);
            return false;
        }
        return this.executePreferencesWriter(new PreferencesWriteAction.PreferencesWriter(){

            public boolean writeToPreferences(Preferences preferences) {
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    SaveInstallerVariablesAction.this.writeValue(preferences, (String)entry.getKey(), (String)entry.getValue());
                }
                return true;
            }
        });
    }
}

