/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.platform.unix.SudoExecution;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class UninstallPreviousAction
extends SystemInstallAction {
    public static final String PROP_UPGRADE_UNINSTALL = "install4j.upgradeUninstall";
    private File installationDirectory;
    private boolean onlyIfSameApplicationId = true;

    public File getInstallationDirectory() {
        return UninstallPreviousAction.replaceVariables(this.installationDirectory);
    }

    public void setInstallationDirectory(File file) {
        this.installationDirectory = file;
    }

    public boolean isOnlyIfSameApplicationId() {
        return this.onlyIfSameApplicationId;
    }

    public void setOnlyIfSameApplicationId(boolean bl) {
        this.onlyIfSameApplicationId = bl;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        try {
            ProgressInterface progressInterface = installerContext.getProgressInterface();
            Logger.getInstance().info(this, "checking running processes");
            if (!RunningProcessChecker.checkRunningProcesses(installerContext, "SetupAppRunningError", true)) {
                throw new UserCanceledException();
            }
            Logger.getInstance().info(this, "checking running processes ok");
            File file = this.getInstallationDirectory();
            File file2 = file == null ? installerContext.getInstallationDirectory() : file;
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            Logger.getInstance().info(this, "getting previous installation id");
            String string = InstallerUtil.getOldApplicationId(file2);
            if (string != null && (this.onlyIfSameApplicationId || installerConfig.getApplicationId().equals(string))) {
                progressInterface.setStatusMessage(Messages.getMessages().getString("StatusUninstallingPrevious"));
                progressInterface.setIndeterminateProgress(true);
                UninstallerThread uninstallerThread = new UninstallerThread(file2);
                Logger.getInstance().info(this, "starting uninstaller");
                uninstallerThread.start();
                while (uninstallerThread.isAlive()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!installerContext.isCancelling()) continue;
                    uninstallerThread.interrupt();
                }
                progressInterface.setIndeterminateProgress(false);
            } else {
                Logger.getInstance().info(this, "no previous installation detected, uninstaller was not started");
            }
            Logger.getInstance().info(this, "finished");
            return true;
        }
        catch (UserCanceledException userCanceledException) {
            Logger.getInstance().info(this, "user cancelled");
            throw userCanceledException;
        }
        catch (Throwable throwable) {
            Logger.getInstance().log(throwable);
            return false;
        }
    }

    private static class UninstallerThread
    extends Thread {
        private File installationDirectory;

        public UninstallerThread(File file) {
            super("uninstaller waiting thread");
            this.installationDirectory = file;
        }

        public void run() {
            try {
                block16: {
                    File file = new File("uninstallPrevious.log");
                    if (InstallerUtil.isMacOS()) {
                        this.runJavaUninstaller(null);
                    } else if (InstallerUtil.isWindows()) {
                        File file2 = new File("i4j_undel.log.tmp");
                        Process process = Runtime.getRuntime().exec(new String[]{new File(this.installationDirectory, "uninstall.exe").getAbsolutePath(), "-q_i4j_internal", "-q", "-Dwindel.logfile=" + file2.getAbsolutePath(), "-Dinstall4j.alternativeLogfile=" + file.getAbsolutePath(), "-Dinstall4j.upgradeUninstall=true"}, null, new File(this.installationDirectory, ".."));
                        try {
                            if (process.waitFor() == 83) {
                                this.runJavaUninstaller(file);
                                break block16;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.deleteWindowsUndelFiles(file2);
                        }
                        catch (InterruptedException interruptedException) {
                            process.destroy();
                        }
                    } else {
                        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
                        Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", new File(this.installationDirectory, installerConfig.getUninstallerPath()).getAbsolutePath(), "-q", "-Dinstall4j.alternativeLogfile=" + file.getAbsolutePath(), "-Dinstall4j.upgradeUninstall=true"}, null, new File(this.installationDirectory, ".."));
                        try {
                            if (process.waitFor() == 83) {
                                this.runJavaUninstaller(file);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            process.destroy();
                        }
                    }
                }
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void runJavaUninstaller(File file) throws IOException {
            File file2 = new File(this.installationDirectory, ".install4j");
            Process process = Runtime.getRuntime().exec(new String[]{new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), "-Dinstall4j.mac_origin=" + SudoExecution.getScrambledPassword(), "-Dinstall4j.upgradeUninstall=true", "-Dinstall4j.alternativeLogfile=" + (file == null ? "null" : file.getAbsolutePath()), "-cp", new File(file2, "i4jruntime.jar").getAbsolutePath() + File.pathSeparator + new File(file2, "user.jar").getAbsolutePath(), "com.install4j.runtime.installer.Uninstaller", "-q"}, null, new File(this.installationDirectory, ".."));
            try {
                Logger.getInstance().info(this, "uninstaller process returned " + process.waitFor());
            }
            catch (InterruptedException interruptedException) {
                process.destroy();
            }
        }

        private void deleteWindowsUndelFiles(File file) throws IOException {
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                if (bufferedReader.readLine() != null) {
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        if (!string.equals("") && !new File(string).delete()) {
                            System.out.println("could not delete " + string);
                        }
                        string = bufferedReader.readLine();
                    }
                }
                bufferedReader.close();
                file.delete();
            } else {
                System.out.println(file + " doesn't exist");
            }
        }
    }
}

