/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.ProgressDelegate;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class InstallFilesAction
extends SystemInstallAction {
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private ScriptProperty fileFilterScript;
    private ScriptProperty directoryResolverScript;
    private ScriptProperty sizeCalculatorScript;
    private boolean showFileNames = true;
    private boolean validateApplicationId = false;
    private boolean checkFreeSpace = true;
    private boolean installRuntime = true;
    private boolean updateBundledJre = true;
    private boolean delay = false;
    private boolean triggerReboot = true;

    public boolean isDelay() {
        return this.delay;
    }

    public void setDelay(boolean bl) {
        this.delay = bl;
    }

    public boolean isTriggerReboot() {
        return this.triggerReboot;
    }

    public void setTriggerReboot(boolean bl) {
        this.triggerReboot = bl;
    }

    public ScriptProperty getFileFilterScript() {
        return this.fileFilterScript;
    }

    public void setFileFilterScript(ScriptProperty scriptProperty) {
        this.fileFilterScript = scriptProperty;
    }

    public ScriptProperty getDirectoryResolverScript() {
        return this.directoryResolverScript;
    }

    public void setDirectoryResolverScript(ScriptProperty scriptProperty) {
        this.directoryResolverScript = scriptProperty;
    }

    public ScriptProperty getSizeCalculatorScript() {
        return this.sizeCalculatorScript;
    }

    public void setSizeCalculatorScript(ScriptProperty scriptProperty) {
        this.sizeCalculatorScript = scriptProperty;
    }

    public boolean isShowFileNames() {
        return this.showFileNames;
    }

    public void setShowFileNames(boolean bl) {
        this.showFileNames = bl;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean bl) {
        this.validateApplicationId = bl;
    }

    public boolean isCheckFreeSpace() {
        return this.checkFreeSpace;
    }

    public void setCheckFreeSpace(boolean bl) {
        this.checkFreeSpace = bl;
    }

    public boolean isInstallRuntime() {
        return this.installRuntime;
    }

    public void setInstallRuntime(boolean bl) {
        this.installRuntime = bl;
    }

    public boolean isUpdateBundledJre() {
        return this.updateBundledJre;
    }

    public void setUpdateBundledJre(boolean bl) {
        this.updateBundledJre = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        File file;
        ContextImpl contextImpl = (ContextImpl)((Object)installerContext);
        this.log();
        ProgressInterface progressInterface = installerContext.getProgressInterface();
        if (!this.showFileNames) {
            progressInterface = new ProgressDelegate(progressInterface){

                public void setDetailMessage(String string) {
                    super.setDetailMessage("");
                }
            };
        }
        if ((file = ContentInstaller.validateInstallationDir(installerContext.getInstallationDirectory(), this.validateApplicationId, this.checkFreeSpace, false, installerContext.isUnattended(), true)) == null) {
            throw new UserCanceledException();
        }
        installerContext.setInstallationDirectory(file);
        ServiceHandler.stopServices(installerContext, false);
        if (this.installRuntime && !RunningProcessChecker.checkRunningProcesses(installerContext, "SetupAppRunningError", true)) {
            throw new UserCanceledException();
        }
        try {
            this.fileInstaller.setLogDir(installerContext.getDestinationFile(".install4j"));
            InstallerEventListener installerEventListener = null;
            if (this.isTriggerReboot() && this.isDelay()) {
                installerEventListener = InstallFilesAction.addRebootTriggerListener(installerContext);
            }
            try {
                ContentInstaller.getInstance().doStandardInstallation(installerContext, progressInterface, this);
            }
            finally {
                if (installerEventListener != null) {
                    installerContext.removeInstallerEventListener(installerEventListener);
                }
            }
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
            ClasspathModificator.addCustomJarsToClasspath(installerContext);
            contextImpl.registerScreens(false);
        }
        catch (IOException iOException) {
            installerContext.handleCriticalException(iOException);
            return false;
        }
        return true;
    }

    private void log() {
        List list = InstallerConfig.getCurrentInstance().getComponents();
        for (int i = 0; i < list.size(); ++i) {
            ComponentConfig componentConfig = (ComponentConfig)list.get(i);
            Logger.getInstance().info(this, "Component " + componentConfig);
        }
    }

    public static InstallerEventListener addRebootTriggerListener(final Context context) {
        InstallerEventListener installerEventListener = new InstallerEventListener(){

            public void installerEvent(InstallerEvent installerEvent) {
                InstallerVariableEvent installerVariableEvent;
                if (installerEvent instanceof InstallerVariableEvent && (installerVariableEvent = (InstallerVariableEvent)installerEvent).getVariableName().equals("sys.rebootRequired") && context.getBooleanVariable("sys.rebootRequired")) {
                    context.triggerReboot(true);
                }
            }
        };
        context.addInstallerEventListener(installerEventListener);
        return installerEventListener;
    }
}

