/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import nanoxml.XMLElement;

public class AutoUninstallHandler {
    private static final String AUTO_UNINSTALL_FILE_PREFIX = "autoUninstall.";
    private static final String ATTRIBUTE_CLASS_NAME = "className";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";

    public static void saveProperties(List list, File file) throws IOException {
        File file2;
        Object object;
        if (list.size() == 0) {
            return;
        }
        XMLElement xMLElement = new XMLElement();
        xMLElement.setName("AutoUninstall");
        for (int i = list.size() - 1; i >= 0; --i) {
            AutoUninstallAction autoUninstallAction = (AutoUninstallAction)list.get(i);
            object = new XMLElement();
            ((XMLElement)object).setName("Action");
            ((XMLElement)object).setAttribute(ATTRIBUTE_CLASS_NAME, autoUninstallAction.getClass().getName());
            Properties properties = autoUninstallAction.getPersistentProperties();
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                XMLElement xMLElement2 = new XMLElement();
                xMLElement2.setName("Property");
                xMLElement2.setAttribute(ATTRIBUTE_NAME, entry.getKey());
                xMLElement2.setAttribute(ATTRIBUTE_VALUE, entry.getValue());
                ((XMLElement)object).addChild(xMLElement2);
            }
            xMLElement.addChild((XMLElement)object);
        }
        int n = 0;
        while ((file2 = new File(file, AUTO_UNINSTALL_FILE_PREFIX + n++)).exists()) {
        }
        object = new BufferedWriter(new FileWriter(file2));
        xMLElement.write((Writer)object);
        ((Writer)object).close();
        FileInstaller.getInstance().registerUninstallFile(file2);
    }

    public static List getAutoUninstallActions(File file) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < file.listFiles().length; ++i) {
            File file2 = file.listFiles()[i];
            String string = file2.getName();
            if (!string.startsWith(AUTO_UNINSTALL_FILE_PREFIX)) continue;
            try {
                int n = Integer.parseInt(string.substring(AUTO_UNINSTALL_FILE_PREFIX.length()));
                arrayList.add(new Integer(n));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        Collections.sort(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            int n = (Integer)arrayList.get(i);
            File file3 = new File(file, AUTO_UNINSTALL_FILE_PREFIX + n);
            AutoUninstallHandler.addAutoUninstallActionsFromFile(file3, arrayList2);
        }
        return arrayList2;
    }

    private static void addAutoUninstallActionsFromFile(File file, List list) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(inputStreamReader);
        inputStreamReader.close();
        Vector vector = xMLElement.getChildren();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            AutoUninstallAction autoUninstallAction = null;
            try {
                autoUninstallAction = (AutoUninstallAction)Class.forName(xMLElement2.getStringAttribute(ATTRIBUTE_CLASS_NAME)).newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (autoUninstallAction == null) continue;
            Properties properties = new Properties();
            Vector vector2 = xMLElement2.getChildren();
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                XMLElement xMLElement3 = (XMLElement)iterator2.next();
                properties.setProperty(xMLElement3.getStringAttribute(ATTRIBUTE_NAME), xMLElement3.getStringAttribute(ATTRIBUTE_VALUE));
            }
            autoUninstallAction.setPersistentProperties(properties);
            list.add(autoUninstallAction);
        }
    }
}

